/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.net;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;

public class CacheConfig
implements Document<CacheConfig> {
    public static CacheConfig OFF = new CacheConfig(false, null, null, null);
    public static CacheConfig DEFAULT = new CacheConfig(true, Duration.ofMinutes(2L), null, 1000);
    private final Duration expireAfterWrite;
    private final Duration expireAfterAccess;
    private final Integer maxSize;
    private final boolean enabled;
    private final DocNode source;

    public CacheConfig(boolean enabled, Duration expireAfterWrite, Duration expireAfterAccess, Integer maxSize) {
        this.enabled = enabled;
        this.expireAfterWrite = expireAfterWrite;
        this.expireAfterAccess = expireAfterAccess;
        this.maxSize = maxSize;
        this.source = null;
    }

    public CacheConfig(DocNode config, Parser.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors);
        this.enabled = vNode.get("enabled").withDefault(true).asBoolean();
        this.expireAfterWrite = vNode.get("expire_after_write").withDefault(CacheConfig.DEFAULT.expireAfterWrite).asDuration();
        this.expireAfterAccess = vNode.get("expire_after_access").asDuration();
        this.maxSize = vNode.get("max_size").withDefault(CacheConfig.DEFAULT.maxSize).asInteger();
        this.source = config;
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
    }

    @Override
    public Object toBasicObject() {
        return this.source;
    }

    public <K, V> Cache<K, V> build() {
        if (!this.enabled) {
            return null;
        }
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.expireAfterWrite != null) {
            cacheBuilder.expireAfterWrite(this.expireAfterWrite);
        }
        if (this.expireAfterAccess != null) {
            cacheBuilder.expireAfterAccess(this.expireAfterAccess);
        }
        if (this.maxSize != null) {
            cacheBuilder.maximumSize((long)this.maxSize.intValue());
        }
        return cacheBuilder.build();
    }

    public <K, V> Cache<K, V> buildWithStats() {
        if (!this.enabled) {
            return null;
        }
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.expireAfterWrite != null) {
            cacheBuilder.expireAfterWrite(this.expireAfterWrite);
        }
        if (this.expireAfterAccess != null) {
            cacheBuilder.expireAfterAccess(this.expireAfterAccess);
        }
        if (this.maxSize != null) {
            cacheBuilder.maximumSize((long)this.maxSize.intValue());
        }
        cacheBuilder.recordStats();
        return cacheBuilder.build();
    }

    public String toString() {
        return "CacheConfig [expireAfterWrite=" + this.expireAfterWrite + ", expireAfterAccess=" + this.expireAfterAccess + ", maxSize=" + this.maxSize + ", enabled=" + this.enabled + "]";
    }
}

